USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_RelatedGoods]') AND name = N'IX_qi_RelatedGoods_GoodsICU_RelationType')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_RelatedGoods_GoodsICU_RelationType] ON {DBOwner}[qi_RelatedGoods]
	(
		[GoodsIC] ASC,
		[GoodsU] ASC,
		[RelationType] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Basket]') AND name = N'IX_qi_Basket_LoginIC_SessionID_LoginU_CreationDate_InternalID')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_Basket_LoginIC_SessionID_LoginU_CreationDate_InternalID] ON {DBOwner}[qi_Basket]
	(
		[LoginIC] ASC,
		[SessionID] ASC,
		[LoginU] ASC,
		[CreationDate] DESC,
		[InternalID] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Goods]') AND name = N'IX_gi_Goods_RepresentativeICU_ICU_DistingAttrGroupICU')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_gi_Goods_RepresentativeICU_ICU_DistingAttrGroupICU] ON {DBOwner}[qi_Goods]
	(
		[RepresentativeU] ASC,
		[RepresentativeIC] ASC,
		[IC] ASC,
		[U] ASC,
		[DistingAttrGroupIC] ASC,
		[DistingAttrGroupU] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_TransportLocations]') AND name = N'PK_qi_TransportLocations')
BEGIN
	ALTER TABLE {DBOwner}[qi_TransportLocations] ADD  CONSTRAINT [PK_qi_TransportLocations] PRIMARY KEY CLUSTERED 
	(
		[IC] ASC,
		[U] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_TransportLocations]') AND name = N'IX_qi_ProcessTransportLocations_TransportProcessIC_TransportLocationICU')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_ProcessTransportLocations_TransportProcessIC_TransportLocationICU] ON {DBOwner}[qi_ProcessTransportLocations]
	(
		[TransportProcessIC] ASC,
		[TransportProcessU] ASC,
		[TransportLocationIC] ASC,
		[TransportLocationU] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END

		


BEGIN TRY
  EXEC sp_updatestats
END TRY
BEGIN CATCH
  -- ignore, probably permissions missing
END CATCH

GO
COMMIT